<?php
namespace App\Http\Requests\Auth\Api;

use Illuminate\Foundation\Http\FormRequest;

class SignupRequest extends FormRequest
{
    protected $guard;
    public function authorize(): bool
    {
        return true;
    }

    protected function prepareForValidation()
    {
        $this->guard = $this->route('guard');
    }

    public function rules(): array
    {
        $table = match ($this->guard) {
            'user-api' => 'users',
            'admin-api' => 'admins',
            'client-api' => 'clients',
            default => 'users',
        };

        return [
            'name'     => ['required', 'string'],
            'email'    => ['required', 'email', "unique:$table,email"],
            'phone'    => ['required', 'string'],
            'password' => ['required', 'string', 'min:6'],
        ];
    }

    public function messages(): array
    {
        return [
            'name.required'     => 'الاسم مطلوب',
            'email.required'    => 'البريد الإلكتروني مطلوب',
            'email.email'       => 'صيغة البريد الإلكتروني غير صحيحة',
            'email.unique'      => 'هذا البريد الإلكتروني مستخدم بالفعل',
            'phone.required'    => 'رقم الهاتف مطلوب',
            'password.required' => 'كلمة المرور مطلوبة',
            'password.min'      => 'كلمة المرور يجب أن تكون 6 أحرف على الأقل',
        ];
    }
}
